<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo esc_html(get_option('signteb_uc_settings')['signteb_uc_title'] ?? 'سایت در حال به‌روزرسانی است'); ?> | ساین طب</title>
    <link rel="icon" type="image/x-icon" href="https://signteb.com/favicon.ico">
    <?php wp_head(); // این تابع استایل‌ها را لود می‌کند ?>
</head>
<body>

<div class="uc-container">
    <header class="uc-header">
        <div class="logo">
            <i class="fas fa-stethoscope"></i>
            <span>ساین طب</span>
        </div>
    </header>

    <main class="uc-main">
        <h1 class="uc-title"><?php echo esc_html(get_option('signteb_uc_settings')['signteb_uc_title'] ?? 'سایت در حال به‌روزرسانی است'); ?></h1>
        <p class="uc-description">
            <?php echo esc_html(get_option('signteb_uc_settings')['signteb_uc_description'] ?? 'ما در حال بهبود تجربه شما هستیم و به زودی باز خواهیم گشت.'); ?>
        </p>

        <div class="progress-container">
            <div class="progress-bar" style="width: 75%;"></div>
        </div>

        <div class="contact-cards">
            <div class="card">
                <i class="fas fa-phone"></i>
                <h3>تماس</h3>
                <p><?php echo esc_html(get_option('signteb_uc_settings')['signteb_uc_phone'] ?? '۰۲۱-۸۸۶۵۳۱۶۰'); ?></p>
            </div>
            <div class="card">
                <i class="fas fa-map-marker-alt"></i>
                <h3>آدرس</h3>
                <p><?php echo esc_html(get_option('signteb_uc_settings')['signteb_uc_address'] ?? 'تهران، ولیعصر، نرسیده به نیایش'); ?></p>
            </div>
        </div>

        <?php $map_url = get_option('signteb_uc_settings')['signteb_uc_map_url']; ?>
        <?php if (!empty($map_url)): ?>
        <div class="map-wrapper">
            <iframe src="<?php echo esc_url($map_url); ?>" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
        <?php endif; ?>

    </main>

    <footer class="uc-footer">
        <a href="<?php echo esc_url(get_option('signteb_uc_settings')['signteb_uc_main_site_url'] ?? 'https://signteb.com/'); ?>" class="main-site-link" target="_blank">
            بازدید از وبسایت اصلی ساین طب
        </a>
        <div class="social-links">
            <?php $instagram = get_option('signteb_uc_settings')['signteb_uc_instagram']; ?>
            <?php if (!empty($instagram) && $instagram !== '#'): ?>
                <a href="<?php echo esc_url($instagram); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
            <?php endif; ?>
            <?php $telegram = get_option('signteb_uc_settings')['signteb_uc_telegram']; ?>
            <?php if (!empty($telegram) && $telegram !== '#'): ?>
                <a href="<?php echo esc_url($telegram); ?>" target="_blank"><i class="fab fa-telegram"></i></a>
            <?php endif; ?>
        </div>
    </footer>
</div>

<?php wp_footer(); // این تابع اسکریپت‌ها را لود می‌کند ?>
</body>
</html>