<?php
/**
 * Plugin Name:       ساین طب - در حال ساخت
 * Plugin URI:        https://signteb.com/
 * Description:       یک صفحه "در حال ساخت" حرفه‌ای با قابلیت مدیریت کامل اطلاعات و رنگ‌بندی از پیشخوان وردپرس.
 * Version:           5.3.0
 * Author:            SignTeb - Theme
 * Author URI:        https://signteb.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       signteb-uc-final
 */

// جلوگیری از دسترسی مستقیم
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// === بخش ۱: ایجاد صفحه تنظیمات در پیشخوان وردپرس ===

add_action('admin_menu', 'signteb_uc_final_add_admin_menu');
add_action('admin_init', 'signteb_uc_final_settings_init');

function signteb_uc_final_add_admin_menu() {
    // ایجاد منوی اصلی برای افزونه
    add_menu_page(
        'تنظیمات ساین طب',            // عنوان صفحه
        'ساین طب - در حال ساخت',       // عنوان منو
        'manage_options',             // قابلیت مورد نیاز
        'signteb_uc_final_settings',  // اسلاگ منو
        'signteb_uc_final_options_page_html', // تابعی که محتوای صفحه را رندر می‌کند
        'dashicons-lock',             // آیکون منو
        25                           // موقعیت منو
    );

    // ایجاد زیرمنوی تنظیمات
    add_submenu_page(
        'signteb_uc_final_settings',  // اسلاگ منوی والد
        'تنظیمات صفحه',              // عنوان زیرمنو
        'تنظیمات صفحه',              // عنوان زیرمنو
        'manage_options',             // قابلیت مورد نیاز
        'signteb_uc_final_settings'   // اسلاگ زیرمنو
    );
}

function signteb_uc_final_settings_init() {
    // ثبت تنظیمات با تابع sanitize سفارشی
    register_setting('signteb_uc_final_plugin_page', 'signteb_uc_final_settings', 'signteb_uc_final_sanitize_options');

    add_settings_section(
        'signteb_uc_final_plugin_page_section',
        'اطلاعات و رنگ‌بندی صفحه "در حال ساخت"',
        'signteb_uc_final_settings_section_callback',
        'signteb_uc_final_plugin_page'
    );

    // فیلدهای اطلاعات تماس
    add_settings_field('signteb_uc_final_website_name', 'نام وبسایت', 'signteb_uc_final_website_name_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_phone', 'شماره تلفن', 'signteb_uc_final_phone_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_address', 'آدرس', 'signteb_uc_final_address_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_map_embed_code', 'کد نقشه گوگل', 'signteb_uc_final_map_embed_code_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_instagram_link', 'لینک اینستاگرام', 'signteb_uc_final_instagram_link_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_telegram_link', 'لینک تلگرام', 'signteb_uc_final_telegram_link_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_whatsapp_link', 'لینک واتس‌اپ', 'signteb_uc_final_whatsapp_link_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');

    // فیلدهای رنگ‌بندی
    add_settings_field('signteb_uc_final_primary_color', 'رنگ پس‌زمینه اصلی', 'signteb_uc_final_primary_color_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_secondary_color', 'رنگ پس‌زمینه ثانویه', 'signteb_uc_final_secondary_color_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_accent_color', 'رنگ دکمه‌ها و هایلایت‌ها', 'signteb_uc_final_accent_color_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_light_color', 'رنگ متن‌های روشن', 'signteb_uc_final_light_color_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
    add_settings_field('signteb_uc_final_gold_color', 'رنگ عناوین اصلی', 'signteb_uc_final_gold_color_render', 'signteb_uc_final_plugin_page', 'signteb_uc_final_plugin_page_section');
}

/**
 * تابع sanitize سفارشی برای پاک‌سازی و ذخیره امن داده‌ها
 */
function signteb_uc_final_sanitize_options( $input ) {
    $new_input = array();
    if ( isset( $input['signteb_uc_final_website_name'] ) )
        $new_input['signteb_uc_final_website_name'] = sanitize_text_field( $input['signteb_uc_final_website_name'] );
    if ( isset( $input['signteb_uc_final_phone'] ) )
        $new_input['signteb_uc_final_phone'] = sanitize_text_field( $input['signteb_uc_final_phone'] );
    if ( isset( $input['signteb_uc_final_address'] ) )
        $new_input['signteb_uc_final_address'] = sanitize_textarea_field( $input['signteb_uc_final_address'] );
    if ( isset( $input['signteb_uc_final_map_embed_code'] ) ) {
        $allowed_html = array( 'iframe' => array( 'src' => array(), 'width' => array(), 'height' => array(), 'style' => array(), 'border' => array(), 'allowfullscreen' => array(), 'loading' => array(), 'referrerpolicy' => array(), 'frameborder' => array(), ) );
        $new_input['signteb_uc_final_map_embed_code'] = wp_kses_post( $input['signteb_uc_final_map_embed_code'] );
    }
    
    // مدیریت لینک‌های اجتماعی برای ذخیره # در صورت خالی بودن
    $instagram_link = isset( $input['signteb_uc_final_instagram_link'] ) ? trim( $input['signteb_uc_final_instagram_link'] ) : '';
    $new_input['signteb_uc_final_instagram_link'] = ! empty( $instagram_link ) ? esc_url_raw( $instagram_link ) : '#';

    $telegram_link = isset( $input['signteb_uc_final_telegram_link'] ) ? trim( $input['signteb_uc_final_telegram_link'] ) : '';
    $new_input['signteb_uc_final_telegram_link'] = ! empty( $telegram_link ) ? esc_url_raw( $telegram_link ) : '#';

    $whatsapp_link = isset( $input['signteb_uc_final_whatsapp_link'] ) ? trim( $input['signteb_uc_final_whatsapp_link'] ) : '';
    $new_input['signteb_uc_final_whatsapp_link'] = ! empty( $whatsapp_link ) ? esc_url_raw( $whatsapp_link ) : '#';

    if ( isset( $input['signteb_uc_final_primary_color'] ) )
        $new_input['signteb_uc_final_primary_color'] = sanitize_hex_color( $input['signteb_uc_final_primary_color'] );
    if ( isset( $input['signteb_uc_final_secondary_color'] ) )
        $new_input['signteb_uc_final_secondary_color'] = sanitize_hex_color( $input['signteb_uc_final_secondary_color'] );
    if ( isset( $input['signteb_uc_final_accent_color'] ) )
        $new_input['signteb_uc_final_accent_color'] = sanitize_hex_color( $input['signteb_uc_final_accent_color'] );
    if ( isset( $input['signteb_uc_final_light_color'] ) )
        $new_input['signteb_uc_final_light_color'] = sanitize_hex_color( $input['signteb_uc_final_light_color'] );
    if ( isset( $input['signteb_uc_final_gold_color'] ) )
        $new_input['signteb_uc_final_gold_color'] = sanitize_hex_color( $input['signteb_uc_final_gold_color'] );

    return $new_input;
}

// توابع رندر کردن فیلدهای اطلاعات
function signteb_uc_final_website_name_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='text' name='signteb_uc_final_settings[signteb_uc_final_website_name]' value='<?php echo esc_attr($options['signteb_uc_final_website_name'] ?? 'ساین طب'); ?>' style="width: 100%;">
    <?php
}
function signteb_uc_final_phone_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='text' name='signteb_uc_final_settings[signteb_uc_final_phone]' value='<?php echo esc_attr($options['signteb_uc_final_phone'] ?? '۸۸۶۵۳۱۶۰,۶۱-۰۲۱'); ?>' style="width: 100%;">
    <?php
}
function signteb_uc_final_address_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <textarea name='signteb_uc_final_settings[signteb_uc_final_address]' rows='4' style="width: 100%;"><?php echo esc_textarea($options['signteb_uc_final_address'] ?? 'ولیعصر، نرسیده به نیایش، کوچه بابک بهرامی، پلاک ۸۵، طبقه ۳'); ?></textarea>
    <?php
}
function signteb_uc_final_map_embed_code_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <textarea name='signteb_uc_final_settings[signteb_uc_final_map_embed_code]' rows='6' style="width: 100%; font-family: monospace;"><?php echo esc_textarea($options['signteb_uc_final_map_embed_code'] ?? ''); ?></textarea>
    <p class="description">کد Embed شده از Google Maps را اینجا قرار دهید.</p>
    <?php
}
function signteb_uc_final_instagram_link_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='url' name='signteb_uc_final_settings[signteb_uc_final_instagram_link]' value='<?php echo esc_url($options['signteb_uc_final_instagram_link'] ?? '#'); ?>' style="width: 100%;">
    <?php
}
function signteb_uc_final_telegram_link_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='url' name='signteb_uc_final_settings[signteb_uc_final_telegram_link]' value='<?php echo esc_url($options['signteb_uc_final_telegram_link'] ?? '#'); ?>' style="width: 100%;">
    <?php
}
function signteb_uc_final_whatsapp_link_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='url' name='signteb_uc_final_settings[signteb_uc_final_whatsapp_link]' value='<?php echo esc_url($options['signteb_uc_final_whatsapp_link'] ?? '#'); ?>' style="width: 100%;">
    <?php
}

// توابع رندر کردن فیلدهای رنگ
function signteb_uc_final_primary_color_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='color' name='signteb_uc_final_settings[signteb_uc_final_primary_color]' value='<?php echo esc_attr($options['signteb_uc_final_primary_color'] ?? '#1a3a8f'); ?>'>
    <?php
}
function signteb_uc_final_secondary_color_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='color' name='signteb_uc_final_settings[signteb_uc_final_secondary_color]' value='<?php echo esc_attr($options['signteb_uc_final_secondary_color'] ?? '#2d5cc2'); ?>'>
    <?php
}
function signteb_uc_final_accent_color_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='color' name='signteb_uc_final_settings[signteb_uc_final_accent_color]' value='<?php echo esc_attr($options['signteb_uc_final_accent_color'] ?? '#4CAF50'); ?>'>
    <?php
}
function signteb_uc_final_light_color_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='color' name='signteb_uc_final_settings[signteb_uc_final_light_color]' value='<?php echo esc_attr($options['signteb_uc_final_light_color'] ?? '#a3d9ff'); ?>'>
    <?php
}
function signteb_uc_final_gold_color_render() {
    $options = get_option('signteb_uc_final_settings');
    ?>
    <input type='color' name='signteb_uc_final_settings[signteb_uc_final_gold_color]' value='<?php echo esc_attr($options['signteb_uc_final_gold_color'] ?? '#FFD700'); ?>'>
    <?php
}

function signteb_uc_final_settings_section_callback() {
    echo 'اطلاعات و رنگ‌بندی مورد نظر برای نمایش در صفحه "در حال ساخت" را وارد کنید.';
}

function signteb_uc_final_options_page_html() {
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields('signteb_uc_final_plugin_page');
            do_settings_sections('signteb_uc_final_plugin_page');
            submit_button('ذخیره تغییرات');
            ?>
        </form>
    </div>
    <?php
}


// === بخش ۲: نمایش صفحه "در حال ساخت" ===

function signteb_uc_final_render_page() {
    $options = get_option('signteb_uc_final_settings');
    $website_name = $options['signteb_uc_final_website_name'] ?? 'ساین طب';
    $phone = $options['signteb_uc_final_phone'] ?? '۸۸۶۵۳۱۶۰,۶۱-۰۲۱';
    $address = $options['signteb_uc_final_address'] ?? 'ولیعصر، نرسیده به نیایش، کوچه بابک بهرامی، پلاک ۸۵، طبقه ۳';
    $map_code = $options['signteb_uc_final_map_embed_code'] ?? '';
    $instagram_link = $options['signteb_uc_final_instagram_link'] ?? '#';
    $telegram_link = $options['signteb_uc_final_telegram_link'] ?? '#';
    $whatsapp_link = $options['signteb_uc_final_whatsapp_link'] ?? '#';

    $primary_color = $options['signteb_uc_final_primary_color'] ?? '#1a3a8f';
    $secondary_color = $options['signteb_uc_final_secondary_color'] ?? '#2d5cc2';
    $accent_color = $options['signteb_uc_final_accent_color'] ?? '#4CAF50';
    $light_color = $options['signteb_uc_final_light_color'] ?? '#a3d9ff';
    $gold_color = $options['signteb_uc_final_gold_color'] ?? '#FFD700';

    $allowed_iframe = array( 'iframe' => array( 'src' => array(), 'width' => array(), 'height' => array(), 'style' => array(), 'border' => array(), 'allowfullscreen' => array(), 'loading' => array(), 'referrerpolicy' => array(), 'frameborder' => array(), ) );
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo esc_html($website_name); ?> | در حال توسعه تجربه‌ای نوین</title>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <link rel="icon" type="image/x-icon" href="https://signteb.com/favicon.ico">
        <style>
            /* فونت فارسی Vazirmatn با بهترین عملکرد */
            @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;700;900&display=swap');

            * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Vazirmatn', sans-serif; }
            :root {
                --primary-color: <?php echo esc_attr($primary_color); ?>;
                --secondary-color: <?php echo esc_attr($secondary_color); ?>;
                --accent-color: <?php echo esc_attr($accent_color); ?>;
                --light-color: <?php echo esc_attr($light_color); ?>;
                --gold-color: <?php echo esc_attr($gold_color); ?>;
                --text-color: #fff;
                --card-bg: rgba(255, 255, 255, 0.1);
            }
            body { background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%); color: var(--text-color); min-height: 100vh; display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 20px; text-align: center; position: relative; overflow-x: hidden; }
            body::before { content: ""; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 100 100"><rect width="100" height="100" fill="none"/><path d="M0,0 L100,100 M100,0 L0,100" stroke="rgba(255,255,255,0.03)" stroke-width="1"/></svg>'); z-index: -1; }
            .particles { position: fixed; top: 0; left: 0; width: 100%; height: 100%; overflow: hidden; z-index: -1; }
            .particle { position: absolute; display: block; pointer-events: none; opacity: 0.3; animation: float 15s infinite; }
            .particle:nth-child(1) { top: 10%; left: 10%; font-size: 20px; animation-delay: 0s; animation-duration: 20s; }
            .particle:nth-child(2) { top: 20%; left: 30%; font-size: 16px; animation-delay: 2s; animation-duration: 25s; }
            .particle:nth-child(3) { top: 50%; left: 50%; font-size: 24px; animation-delay: 4s; animation-duration: 18s; }
            .particle:nth-child(4) { top: 80%; left: 80%; font-size: 18px; animation-delay: 0s; animation-duration: 22s; }
            .particle:nth-child(5) { top: 60%; left: 10%; font-size: 22px; animation-delay: 3s; animation-duration: 19s; }
            .particle:nth-child(6) { top: 30%; left: 70%; font-size: 20px; animation-delay: 1s; animation-duration: 21s; }
            @keyframes float { 0% { transform: translateY(0) rotate(0deg); opacity: 0; } 10% { opacity: 0.3; } 90% { opacity: 0.3; } 100% { transform: translateY(-100vh) rotate(720deg); opacity: 0; } }
            .container { max-width: 900px; width: 100%; background-color: var(--card-bg); backdrop-filter: blur(10px); border-radius: 20px; padding: 40px; box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2); border: 1px solid rgba(255, 255, 255, 0.1); position: relative; overflow: hidden; animation: fadeIn 1s ease-out; }
            .container::before { content: ""; position: absolute; top: -50%; left: -50%; width: 200%; height: 200%; background: radial-gradient(circle, rgba(255,255,255,0.05) 0%, rgba(255,255,255,0) 70%); animation: rotate 30s linear infinite; z-index: -1; }
            @keyframes fadeIn { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
            @keyframes rotate { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
            .logo-container { display: flex; align-items: center; justify-content: center; gap: 20px; margin-bottom: 25px; flex-wrap: wrap; position: relative; }
            .logo { font-size: 3.5rem; color: var(--accent-color); animation: pulse 2s infinite; position: relative; }
            .logo::after { content: ""; position: absolute; top: 50%; left: 50%; width: 120%; height: 120%; background: radial-gradient(circle, rgba(76, 175, 80, 0.3) 0%, rgba(76, 175, 80, 0) 70%); transform: translate(-50%, -50%); animation: pulse 2s infinite; z-index: -1; }
            @keyframes pulse { 0% { transform: scale(1); } 50% { transform: scale(1.05); } 100% { transform: scale(1); } }
            .company-name { font-size: 2.8rem; font-weight: bold; color: var(--text-color); text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3); position: relative; }
            .company-name::after { content: ""; position: absolute; bottom: -5px; right: 0; width: 0; height: 3px; background: linear-gradient(90deg, var(--accent-color), var(--light-color)); animation: expandWidth 2s forwards; }
            @keyframes expandWidth { to { width: 100%; } }
            .slogan { font-size: 1.4rem; color: var(--light-color); margin-bottom: 25px; font-style: italic; line-height: 1.6; opacity: 0; animation: fadeIn 1s ease-out 0.5s forwards; }
            h1 { font-size: 2.5rem; margin-bottom: 15px; text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3); color: var(--gold-color); position: relative; display: inline-block; }
            h1::after { content: ""; position: absolute; bottom: -5px; left: 0; width: 100%; height: 3px; background: linear-gradient(90deg, transparent, var(--gold-color), transparent); animation: slide 2s infinite; }
            @keyframes slide { 0% { transform: translateX(-100%); } 100% { transform: translateX(100%); } }
            .subtitle { font-size: 1.3rem; margin-bottom: 30px; opacity: 0.9; line-height: 1.6; animation: fadeIn 1s ease-out 0.7s forwards; opacity: 0; }
            .thank-you { color: var(--accent-color); font-weight: bold; font-size: 1.2rem; margin: 15px 0; padding: 10px; background-color: rgba(76, 175, 80, 0.1); border-radius: 10px; border-right: 4px solid var(--accent-color); position: relative; overflow: hidden; }
            .thank-you::before { content: ""; position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent); animation: shine 3s infinite; }
            @keyframes shine { 0% { left: -100%; } 20% { left: 100%; } 100% { left: 100%; } }
            .construction-icon { font-size: 5rem; color: var(--gold-color); margin: 30px 0; position: relative; display: inline-block; }
            .construction-icon i { animation: rotate 3s linear infinite; }
            .construction-icon::after { content: ""; position: absolute; top: 50%; left: 50%; width: 150%; height: 150%; background: radial-gradient(circle, rgba(255, 215, 0, 0.2) 0%, rgba(255, 215, 0, 0) 70%); transform: translate(-50%, -50%); animation: pulse 2s infinite; z-index: -1; }
            .progress-container { width: 100%; background-color: rgba(255, 255, 255, 0.2); border-radius: 10px; margin: 30px 0; overflow: hidden; height: 20px; position: relative; }
            .progress-bar { height: 100%; width: 75%; background: linear-gradient(90deg, var(--accent-color), #8BC34A); border-radius: 10px; position: relative; overflow: hidden; }
            .progress-bar::after { content: ""; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent); animation: shine 2s infinite; }
            .progress-text { position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); font-weight: bold; font-size: 0.9rem; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5); }
            .contact-info { margin-top: 30px; padding: 25px; background-color: rgba(255, 255, 255, 0.08); border-radius: 15px; text-align: right; position: relative; overflow: hidden; }
            .contact-info::before { content: ""; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 100 100"><rect width="100" height="100" fill="none"/><path d="M0,0 L100,100 M100,0 L0,100" stroke="rgba(255,255,255,0.03)" stroke-width="1"/></svg>'); z-index: -1; }
            .contact-title { font-size: 1.8rem; margin-bottom: 20px; color: var(--gold-color); text-align: center; position: relative; display: inline-block; }
            .contact-title::after { content: ""; position: absolute; bottom: -5px; right: 0; width: 100%; height: 3px; background: linear-gradient(90deg, var(--gold-color), transparent); }
            .contact-details { display: flex; flex-wrap: wrap; justify-content: space-between; gap: 20px; margin-bottom: 20px; }
            .contact-item { flex: 1; min-width: 250px; padding: 15px; background-color: rgba(255, 255, 255, 0.05); border-radius: 10px; text-align: right; transition: all 0.3s ease; position: relative; overflow: hidden; }
            .contact-item::before { content: ""; position: absolute; top: 0; right: 0; width: 5px; height: 100%; background: linear-gradient(to bottom, var(--accent-color), var(--light-color)); transform: scaleY(0); transition: transform 0.3s ease; }
            .contact-item:hover::before { transform: scaleY(1); }
            .contact-item:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2); }
            .contact-item i { color: var(--accent-color); margin-left: 10px; font-size: 1.5rem; vertical-align: middle; transition: all 0.3s ease; }
            .contact-item:hover i { transform: scale(1.2); }
            .contact-item h3 { color: var(--light-color); margin-bottom: 10px; font-size: 1.3rem; border-bottom: 1px solid rgba(255, 255, 255, 0.1); padding-bottom: 8px; }
            .map-container { margin-top: 15px; border-radius: 10px; overflow: hidden; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2); }
            .map-container iframe { width: 100%; height: 300px; border: 0; }
            .website-link { display: inline-block; margin-top: 25px; padding: 12px 30px; background: linear-gradient(90deg, var(--accent-color), #2E7D32); color: white; text-decoration: none; border-radius: 50px; font-size: 1.2rem; font-weight: bold; transition: all 0.3s ease; box-shadow: 0 5px 15px rgba(46, 125, 50, 0.3); position: relative; overflow: hidden; }
            .website-link::before { content: ""; position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent); transition: left 0.5s ease; }
            .website-link:hover::before { left: 100%; }
            .website-link:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(46, 125, 50, 0.4); background: linear-gradient(90deg, #2E7D32, var(--accent-color)); }
            .website-link i { margin-right: 8px; transition: all 0.3s ease; }
            .website-link:hover i { transform: rotate(360deg); }
            .social-icons { display: flex; justify-content: center; gap: 25px; margin-top: 30px; }
            .social-icons a { color: white; font-size: 2rem; transition: all 0.3s ease; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; background-color: rgba(255, 255, 255, 0.1); position: relative; overflow: hidden; }
            .social-icons a::before { content: ""; position: absolute; top: 50%; left: 50%; width: 0; height: 0; background-color: rgba(255, 255, 255, 0.2); border-radius: 50%; transform: translate(-50%, -50%); transition: all 0.5s ease; }
            .social-icons a:hover::before { width: 100%; height: 100%; }
            .social-icons a:hover { color: var(--accent-color); transform: translateY(-5px) rotate(360deg); }
            .copyright { margin-top: 40px; opacity: 0.8; font-size: 0.9rem; color: var(--light-color); }
            @media (max-width: 768px) { .container { padding: 30px 20px; } .company-name { font-size: 2.2rem; } h1 { font-size: 2rem; } .slogan, .subtitle { font-size: 1.1rem; } .construction-icon { font-size: 4rem; } .contact-details { flex-direction: column; } .contact-item { min-width: 100%; } .map-container iframe { height: 250px; } }
            @media (max-width: 480px) { .company-name { font-size: 1.8rem; } h1 { font-size: 1.6rem; } .slogan, .subtitle { font-size: 1rem; } .construction-icon { font-size: 3rem; } .website-link { padding: 10px 20px; font-size: 1rem; } .social-icons a { width: 50px; height: 50px; font-size: 1.6rem; } .map-container iframe { height: 200px; } }
        </style>
    </head>
    <body>
        <div class="particles">
            <span class="particle"><i class="fas fa-heartbeat"></i></span>
            <span class="particle"><i class="fas fa-stethoscope"></i></span>
            <span class="particle"><i class="fas fa-user-md"></i></span>
            <span class="particle"><i class="fas fa-pills"></i></span>
            <span class="particle"><i class="fas fa-hospital"></i></span>
            <span class="particle"><i class="fas fa-heart"></i></span>
        </div>
        
        <div class="container">
            <div class="logo-container">
                <div class="logo"><i class="fas fa-stethoscope"></i></div>
                <div>
                    <div class="company-name"><?php echo esc_html($website_name); ?></div>
                    <div class="slogan">در حال ساخت با ❤️ توسط <?php echo esc_html($website_name); ?></div>
                </div>
            </div>
            
            <h1>در حال توسعه تجربه‌ای نوین</h1>
            
            <p class="subtitle">
                ما با افتخار در حال طراحی و ساخت پلتفرمی نوین برای ارائه خدمات پزشکی با کیفیت هستیم. به زودی با تجربه‌ای متفاوت و کاربرپسند در خدمت شما خواهیم بود.
            </p>
            
            <div class="thank-you">
                از صبر و همراهی شما سپاسگزاریم. به زودی با سایتی کامل‌تر و کارآمدتر بازخواهیم گشت.
            </div>
            
            <div class="construction-icon">
                <i class="fas fa-hard-hat"></i>
            </div>
            
            <div class="progress-container">
                <div class="progress-bar"></div>
                <div class="progress-text">در حال پیشرفت...</div>
            </div>
            
            <div class="contact-info">
                <div class="contact-title">ارتباط با <?php echo esc_html($website_name); ?></div>
                
                <div class="contact-details">
                    <div class="contact-item">
                        <h3><i class="fas fa-phone"></i> تلفن تماس</h3>
                        <p><?php echo esc_html($phone); ?></p>
                    </div>
                    
                    <div class="contact-item">
                        <h3><i class="fas fa-map-marker-alt"></i> آدرس</h3>
                        <p><?php echo nl2br(esc_textarea($address)); ?></p>
                    </div>
                </div>

                <div class="contact-item" style="width: 100%;">
                    <h3><i class="fas fa-map"></i> موقعیت روی نقشه</h3>
                    <div class="map-container">
                        <?php echo wp_kses($map_code, $allowed_iframe); ?>
                    </div>
                </div>
                
                <!-- لینک به صفحه افزونه‌ها -->
                <a href="https://signteb.com/category/wordpress-plugin/" class="website-link" target="_blank">
                    <i class="fas fa-external-link-alt"></i>
                    مشاهده وبسایت ساین طب
                </a>
                
                <div class="social-icons">
                    <a href="<?php echo esc_url($instagram_link); ?>" title="اینستاگرام" target="_blank"><i class="fab fa-instagram"></i></a>
                    <a href="<?php echo esc_url($telegram_link); ?>" title="تلگرام" target="_blank"><i class="fab fa-telegram"></i></a>
                    <a href="<?php echo esc_url($whatsapp_link); ?>" title="واتس‌اپ" target="_blank"><i class="fab fa-whatsapp"></i></a>
                </div>
            </div>
            
            <div class="copyright">
                © کلیه حقوق مادی و معنوی این وبسایت متعلق به <?php echo esc_html($website_name); ?> می‌باشد - <?php echo date('Y'); ?>
            </div>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const progressBar = document.querySelector('.progress-bar');
                const progressText = document.querySelector('.progress-text');
                if(progressBar && progressText) {
                    let progressWidth = 75;
                    let increasing = true;
                    setInterval(() => {
                        if (increasing) { progressWidth += 0.5; if (progressWidth >= 80) increasing = false; }
                        else { progressWidth -= 0.5; if (progressWidth <= 75) increasing = true; }
                        progressBar.style.width = `${progressWidth}%`;
                        progressText.textContent = `در حال پیشرفت... ${Math.round(progressWidth)}%`;
                    }, 500);
                }
                const websiteLink = document.querySelector('.website-link');
                if(websiteLink) { websiteLink.addEventListener('mouseenter', function() { this.style.transform = 'translateY(-5px) scale(1.05)'; }); websiteLink.addEventListener('mouseleave', function() { this.style.transform = 'translateY(0) scale(1)'; }); }
                const thankYou = document.querySelector('.thank-you');
                if(thankYou) { let thankYouOpacity = 1; let thankYouDirection = -0.02; setInterval(() => { thankYouOpacity += thankYouDirection; if (thankYouOpacity <= 0.7) thankYouDirection = 0.02; if (thankYouOpacity >= 1) thankYouDirection = -0.02; thankYou.style.opacity = thankYouOpacity; }, 100); }
                const socialIcons = document.querySelectorAll('.social-icons a');
                socialIcons.forEach(icon => { icon.addEventListener('mouseenter', function() { this.style.transform = 'translateY(-5px) rotate(360deg)'; }); icon.addEventListener('mouseleave', function() { this.style.transform = 'translateY(0) rotate(0)'; }); });
                const contactItems = document.querySelectorAll('.contact-item');
                contactItems.forEach(item => { item.addEventListener('mouseenter', function() { this.style.transform = 'translateY(-5px)'; this.style.boxShadow = '0 10px 20px rgba(0, 0, 0, 0.2)'; }); item.addEventListener('mouseleave', function() { this.style.transform = 'translateY(0)'; this.style.boxShadow = 'none'; }); });
                const mainTitle = document.querySelector('h1');
                if(mainTitle) { mainTitle.addEventListener('mouseenter', function() { this.style.transform = 'scale(1.05)'; }); mainTitle.addEventListener('mouseleave', function() { this.style.transform = 'scale(1)'; }); }
                const particlesContainer = document.querySelector('.particles');
                const particleIcons = ['fa-heartbeat', 'fa-stethoscope', 'fa-user-md', 'fa-pills', 'fa-hospital', 'fa-heart'];
                for (let i = 0; i < 10; i++) { const particle = document.createElement('span'); particle.classList.add('particle'); const icon = document.createElement('i'); icon.classList.add('fas'); icon.classList.add(particleIcons[Math.floor(Math.random() * particleIcons.length)]); particle.appendChild(icon); particle.style.top = `${Math.random() * 100}%`; particle.style.left = `${Math.random() * 100}%`; particle.style.fontSize = `${Math.random() * 10 + 15}px`; particle.style.animationDelay = `${Math.random() * 5}s`; particle.style.animationDuration = `${Math.random() * 10 + 15}s`; particlesContainer.appendChild(particle); }
            });
        </script>
    </body>
    </html>
    <?php
    exit;
}

function signteb_uc_final_check_and_display() {
    if ( current_user_can( 'manage_options' ) || $GLOBALS['pagenow'] === 'wp-login.php' ) {
        return;
    }
    signteb_uc_final_render_page();
}
add_action( 'template_redirect', 'signteb_uc_final_check_and_display' );